#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_VBECSDateTime : BaseTest
	{
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}

		[Test]
		public void GetDivisionTimeZone_Pass()
		{
			string timeZone = BOL.VBECSDateTime.GetDivisionTimeZone();
			//
			Assert.IsTrue( timeZone != null && timeZone.Length > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDivisionTimeZone_Fail()
		{
		}

		[Test]
		public void GetDivisionTimeZoneAbbreviation_Pass()
		{
			string timeZoneAbbrev = BOL.VBECSDateTime.GetDivisionTimeZoneAbbreviation();
			//
			Assert.IsTrue( timeZoneAbbrev != null && timeZoneAbbrev.Length > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDivisionTimeZoneAbbreviation_Fail()
		{
		}

		[Test]
		public void GetDivisionCurrentDateTime_Pass()
		{
			DateTime currentTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			//
			Assert.IsTrue( !currentTime.Equals( DateTime.MinValue ) );
			Assert.IsTrue( !currentTime.Equals( DateTime.MaxValue ) );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDivisionCurrentDateTime_Fail()
		{
		}

		[Test]
		public void GetDivisionCurrentDateTime_String_Param_Pass()
		{
			DateTime currentTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime( UnitTestConfig.TestDivisionCode );
			//
			Assert.IsTrue( !currentTime.Equals( DateTime.MinValue ) );
			Assert.IsTrue( !currentTime.Equals( DateTime.MaxValue ) );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDivisionCurrentDateTime_String_Param_Fail()
		{
		}
	}
}
#endif
